require("dotenv").config();
const express = require("express");
const fs = require("fs");
const cors = require('cors');
const https = require('https');
const Router = require("./routes/router");
const path = require("path");



// Assigning Express Here
const app = express();

app.use(express.json());

// Handling SSL and its files

const options = {
  cert: fs.readFileSync(path.resolve(__dirname, "fclubbyftv.crt")),
  key: fs.readFileSync(path.resolve(__dirname, "fclubbyftv.key")),
};


// Handling CORS Enviroment Here 

let corsOptions = {};
if(process.env.NODE_ENV === 'production') {
    corsOptions = {
        origin: ["https://fpageantsbyftv.ae", "http://localhost:3032"],
        methods: "GET,POST",
        credentials: true,
    }
} else {
    corsOptions = {
        origin: "*",
      };
}

// Routing Assign Here

app.use("/api/enquiry", Router);

app.get("/", (req, res) => {
  res.send("Welcome to the node Server !");
});


// CORS Assiging Here 

app.use(cors(corsOptions));

// Handling HTTPS Request Here for Production

const server = https.createServer(options, app);

// Assign PORT Here
const PORT = process.env.PORT || 9090;

// Making PORT Listening Here
server.listen(process.env.PORT, () => {
  console.log(`Server is Running at Port ${PORT}`);
});
