const { createUser, login, createEnquiry, getmeta, subscribe } = require('../api/controller');
const { checkToken } = require('../auth/token_validation');
const { uploadPortfolio } = require('../auth/upload');

const router = require('express').Router();

// Auth API Routes 
router.post("/user" ,checkToken, createUser);
router.post("/login", login);

// Enquiry (public for landing page https://fpageantsbyftv.ae) - multipart/form-data with PDF portfolio
router.post("/", (req, res, next) => {
  uploadPortfolio(req, res, (err) => {
    if (err) {
      return res.status(400).json({ status: "error", message: [err.message || "File upload failed."] });
    }
    next();
  });
}, createEnquiry);
router.get("/fetchmeta/:metasource", checkToken, getmeta);

// subscribe Route Here 

router.get("/subscribe/:email", checkToken, subscribe);





module.exports = router;